Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapGenScript = LevelUtils.MapGenFromSVG([[AS_Testbed.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 0.0,
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		Default = [[inactive]],
		FreeUpgradesDefault = [[active]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnDebugCall = function (mousePos)


	end
}

ScriptMgr:DoDelayedCall(500,
	function ()
		local startEnt = GameWorld:GetEntityById("startArea");
		local endEnt = GameWorld:GetEntityById("endArea");
		if not startEnt or not endEnt then
			return
		end

		local spawnV = startEnt:GetPos()
		local offsetV = (endEnt:GetPos() - startEnt:GetPos()):Normalize():Rotate90CW()
		
		--[[ WEAPON TYPES
		WeaponType.WT_AUTORIFLE
		WeaponType.WT_FUSIONRIFLE
		WeaponType.WT_SNIPERRIFLE
		WeaponType.WT_FLAMETHROWER
		WeaponType.WT_SABOTEUR
		WeaponType.WT_MEDIC
		WeaponType.WT_MINIGUN
		--]]
		
		--WEAPON SETTINGS--
		local marineWeapons = {}
		marineWeapons[1] = WeaponType.WT_FUSIONRIFLE
		marineWeapons[2] = WeaponType.WT_MEDIC
		marineWeapons[3] = WeaponType.WT_FLAMETHROWER
		marineWeapons[4] = WeaponType.WT_AUTORIFLE
		marineWeapons[5] = WeaponType.WT_MINIGUN
		
		
		local nSpawn = 5
		for i=1,nSpawn do
			local deltaV = offsetV * 4.5 * (i - nSpawn/2) --vect2f.MakePolar(startEnt:GetRadius(), i/nSpawn*math.pi*2)
			-- Should use the game's random generator here
			
			local marine = GameWorld:CreateEntity("AIMarine", "", spawnV + deltaV)
			marine = marine:ToCHuman()
			
			if marine then
				if marineWeapons[i] then
					marine:SetWeaponType(marineWeapons[i])
				end
			
				marine:CommandAssaultTo(endEnt:GetPos() + deltaV)
			end
		end	
	end)



